﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.UI;

//using Obi;

public class FifthLevelTrigger : MonoBehaviour
{
    //public Transform m_topTrans;
    //private Rigidbody[] m_rigidBody;
    //private bool m_bControl = true;
    //public Transform m_mousePosTrans;
    //public float m_speed = 1.0f;
    //private bool m_bEnterGround = true;
    //private bool m_bEnterSuccessTarget = false;
    //private Rigidbody m_mouseRigidBody;
    //private Vector3 m_DefaultPos = new Vector3(2.18f,1.61f,-1.13f);
    //private Vector3 m_dirPos = new Vector3(1.19f, 0, -2.11f);

    //private void Start()
    //{
    //    m_mouseRigidBody = m_mousePosTrans.gameObject.GetComponent<Rigidbody>();
    //    BattleCtrl.instance.levelManager.curLevel.chainRopeView.onBalloonEnterTarget += onBalloonEnterTarget;
    //    BattleCtrl.instance.levelManager.curLevel.chainRopeView.onBalloonEnterGround += onBalloonEnterGround;
    //    BattleCtrl.instance.levelManager.curLevel.chainRopeView.onBalloonEnterSuccessTarget += onBalloonEnterSuccessTarget;
    //    //m_rigidBody = gameObject.GetComponentsInChildren<Rigidbody>();
    //}
    //void onBalloonEnterTarget()
    //{
    //    m_bEnterGround = false;
    //}
    //void onBalloonEnterGround()
    //{
    //    m_bEnterGround = true;
    //}
    //void onBalloonEnterSuccessTarget()
    //{
    //    m_bEnterSuccessTarget = true;
    //}
    //// Update is called once per frame
    //void Update()
    //{
    //    //if(m_bControl)
    //    //{
    //    //    if(m_topTrans.position.y < 6)
    //    //    {
    //    //        m_bControl = false;
    //    //        BattleCtrl.instance.OnBattleWin();
    //    //    }
    //    //}
    //    if(m_bEnterGround)
    //    {
    //        transform.Translate(Vector3.up * Time.deltaTime * m_speed, Space.World);
    //    }
    //    if(m_bEnterSuccessTarget)
    //    {
    //        m_bEnterSuccessTarget = false;
    //        m_mouseRigidBody.isKinematic = true;
    //        m_mousePosTrans.localPosition = m_DefaultPos;
    //    }
    //    else
    //    {
    //        if(m_mouseRigidBody.isKinematic)
    //        {
    //            //transform.Translate(Vector3.up * Time.deltaTime * m_speed, Space.World);
    //            transform.localPosition = Vector3.Lerp(transform.localPosition, m_dirPos, 0.03f);
    //            transform.rotation = Quaternion.Slerp(transform.rotation, Quaternion.identity, 0.03f);
    //        }
    //    }
    //}

    public Color mColor = Color.black;//画笔颜色
    //[HideInInspector]
    public Texture brushTexture;//画笔
    [HideInInspector]
    public float brushScale = 0.1f;//画笔大小
    [HideInInspector]
    public bool isEraser = false;//是否使用橡皮擦
    private RenderTexture texRender;//接收图的RenderTexture
    private Material mat;//材质球
    private RawImage rImage;//RawImage,自身
    private RectTransform rTransform;//RectTransform

    private Vector3 startPosition = Vector3.zero;
    private Vector3 endPosition = Vector3.zero;

    private Vector2 posOffset;

    private void Start()
    {
        SetPainting();
        posOffset.Set((Screen.width - rTransform.sizeDelta.x * transform.root.localScale.x) / 2 + transform.position.x - transform.root.position.x, (Screen.height - rTransform.sizeDelta.y * transform.root.localScale.y) / 2 + transform.position.y - transform.root.position.y);
    }

    void OnGUI()
    {
        //if (MouseOverController.GetOverUI(transform.root.gameObject) == null)
        //{
        //    EndPainting();
        //    return;
        //}
        //else if (MouseOverController.GetOverUI(transform.root.gameObject).name != gameObject.name)
        //{
        //    EndPainting();
        //    return;
        //}

        if (Input.GetMouseButton(0))
        {
            StartPainting(new Vector3(Input.mousePosition.x - posOffset.x, Input.mousePosition.y - posOffset.y, 0));
        }
        if (Input.GetMouseButtonUp(0))
        {
            EndPainting();
        }
    }

    /// <summary>
    /// 初始化设置
    /// </summary>
    public void SetPainting()
    {
        rTransform = GetComponent<RectTransform>();
        mat = new Material(Shader.Find("Custom/Painting"));
        texRender = new RenderTexture((int)rTransform.sizeDelta.x, (int)rTransform.sizeDelta.y, 24, RenderTextureFormat.ARGB32);
        Clear(texRender);
        rImage = GetComponent<RawImage>();
        Debug.Log(rImage);
        rImage.texture = texRender;
    }

    /// <summary>
    /// 开始画线
    /// </summary>
    /// <param name="pos"></param>
    public void StartPainting(Vector3 pos)
    {
        endPosition = pos;

        if (startPosition.Equals(Vector3.zero))
        {
            startPosition = endPosition;
            return;
        }

        float distance = Vector3.Distance(startPosition, endPosition);
        if (distance > 1)
        {
            int d = (int)distance;
            for (int i = 0; i < d; i++)
            {
                float difx = endPosition.x - startPosition.x;
                float dify = endPosition.y - startPosition.y;
                float delta = (float)i / distance;
                if (isEraser)
                {
                    DrawBrush(texRender, new Vector2(startPosition.x + (difx * delta), startPosition.y + (dify * delta)), brushTexture, Color.white, brushScale);
                }
                else
                {
                    DrawBrush(texRender, new Vector2(startPosition.x + (difx * delta), startPosition.y + (dify * delta)), brushTexture, mColor, brushScale);
                }
            }
        }
        startPosition = endPosition;
    }

    /// <summary>
    /// 结束画线
    /// </summary>
    public void EndPainting()
    {
        startPosition = Vector3.zero;
    }

    private void DrawBrush(RenderTexture destTexture, Vector2 pos, Texture sourceTexture, Color color, float scale)
    {
        DrawBrush(destTexture, (int)pos.x, (int)pos.y, sourceTexture, color, scale);
    }

    private void DrawBrush(RenderTexture destTexture, int x, int y, Texture sourceTexture, Color color, float scale)
    {
        DrawBrush(destTexture, new Rect(x, y, sourceTexture.width, sourceTexture.height), sourceTexture, color, scale);
    }

    private void DrawBrush(RenderTexture destTexture, Rect destRect, Texture sourceTexture, Color color, float scale)
    {
        //Graphics.SetRenderTarget(destTexture);

        float left = destRect.xMin - destRect.width * scale / 2.0f;
        float right = destRect.xMin + destRect.width * scale / 2.0f;
        float top = destRect.yMin - destRect.height * scale / 2.0f;
        float bottom = destRect.yMin + destRect.height * scale / 2.0f;
        Debug.LogError("AAAAA");
        GL.PushMatrix();
        GL.LoadOrtho();

        mat.SetTexture("_MainTex", brushTexture);
        mat.SetColor("_Color", color);
        mat.SetPass(0);

        GL.Begin(GL.QUADS);

        /*GL.TexCoord2(0.0f, 0.0f); */GL.Vertex3(left / (int)rTransform.sizeDelta.x / transform.root.localScale.x, top / (int)rTransform.sizeDelta.y / transform.root.localScale.y, 0);
        /*GL.TexCoord2(1.0f, 0.0f); */GL.Vertex3(right / (int)rTransform.sizeDelta.x / transform.root.localScale.x, top / (int)rTransform.sizeDelta.y / transform.root.localScale.y, 0);
        /*GL.TexCoord2(1.0f, 1.0f); */GL.Vertex3(right / (int)rTransform.sizeDelta.x / transform.root.localScale.x, bottom / (int)rTransform.sizeDelta.y / transform.root.localScale.y, 0);
        /*GL.TexCoord2(0.0f, 1.0f); */GL.Vertex3(left / (int)rTransform.sizeDelta.x / transform.root.localScale.x, bottom / (int)rTransform.sizeDelta.y / transform.root.localScale.y, 0);

        GL.End();
        GL.PopMatrix();
    }

    /// <summary>
    /// 重置RenderTexture
    /// </summary>
    /// <param name="destTexture"></param>
    private void Clear(RenderTexture destTexture)
    {
        Graphics.SetRenderTarget(destTexture);
        GL.PushMatrix();
        GL.Clear(true, true, Color.white);
        GL.PopMatrix();
    }

    /// <summary>
    /// 外部可以调用的重置修改的RenderTexture
    /// </summary>
    public void ClearAll()
    {
        Clear(texRender);
    }
}
